package pl.gda.pg.concurrency.forks;

import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RecursiveTask;

public class RecursiveAdder extends RecursiveAction {

    double[] arrayOfNumbers;
    int startIndex;
    int endIndex;
    private static int FORK_LIMIT = 10;

    public RecursiveAdder(double[] arrayOfNumbers, int startIndex, int endIndex) {
        this.arrayOfNumbers = arrayOfNumbers;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    protected void compute() {
        if (endIndex - startIndex <= FORK_LIMIT) {
            for (int i = startIndex; i <= endIndex; i++) {
                arrayOfNumbers[i]++;
            }
            for (int delay = 0; delay < 10000; delay++) {
                double d = 1.23 * 4.56;
                double dd = d++;
            }
        } else {
            int splitLength = (endIndex - startIndex) / 2;
            RecursiveAdder adder1 = new RecursiveAdder(arrayOfNumbers, startIndex, startIndex + splitLength);
            RecursiveAdder adder2 = new RecursiveAdder(arrayOfNumbers, startIndex + splitLength + 1, endIndex);
            invokeAll(adder1, adder2);
        }
    }

}
